# type: ignore
from __future__ import annotations
import openvino._pyopenvino
import openvino._pyopenvino.properties.hint
import typing
"""
openvino.properties.intel_gpu.hint submodule that simulates ov::intel_gpu::hint
"""
__all__: list[str] = ['ThrottleLevel', 'available_device_mem', 'enable_lora_operation', 'host_task_priority', 'queue_priority', 'queue_throttle']
class ThrottleLevel:
    """
    openvino.properties.intel_gpu.hint.ThrottleLevel that simulates ov::intel_gpu::hint::ThrottleLevel
    """
    DEFAULT: typing.ClassVar[openvino._pyopenvino.properties.hint.Priority]  # value = <Priority.MEDIUM: 1>
    HIGH: typing.ClassVar[openvino._pyopenvino.properties.hint.Priority]  # value = <Priority.HIGH: 2>
    LOW: typing.ClassVar[openvino._pyopenvino.properties.hint.Priority]  # value = <Priority.LOW: 0>
    MEDIUM: typing.ClassVar[openvino._pyopenvino.properties.hint.Priority]  # value = <Priority.MEDIUM: 1>
@typing.overload
def available_device_mem() -> str:
    ...
@typing.overload
def available_device_mem(arg0: typing.SupportsInt) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
@typing.overload
def enable_lora_operation() -> str:
    ...
@typing.overload
def enable_lora_operation(arg0: bool) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
@typing.overload
def host_task_priority() -> str:
    ...
@typing.overload
def host_task_priority(arg0: openvino._pyopenvino.properties.hint.Priority) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
@typing.overload
def queue_priority() -> str:
    ...
@typing.overload
def queue_priority(arg0: openvino._pyopenvino.properties.hint.Priority) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
@typing.overload
def queue_throttle() -> str:
    ...
@typing.overload
def queue_throttle(arg0: openvino._pyopenvino.properties.hint.Priority) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
