# type: ignore
from __future__ import annotations
import openvino._pyopenvino
import typing
"""
module openvino.op.util
"""
__all__: list[str] = ['ArithmeticReduction', 'BinaryElementwiseArithmetic', 'BinaryElementwiseComparison', 'BinaryElementwiseLogical', 'BodyOutputDescription', 'ConcatOutputDescription', 'IndexReduction', 'InputDescription', 'InvariantInputDescription', 'MergedInputDescription', 'OutputDescription', 'SliceInputDescription', 'UnaryElementwiseArithmetic', 'Variable', 'VariableInfo']
class ArithmeticReduction:
    reduction_axes: openvino._pyopenvino.AxisSet
    def __repr__(self) -> str:
        ...
    def get_reduction_axes(self) -> openvino._pyopenvino.AxisSet:
        ...
    def set_reduction_axes(self, arg0: openvino._pyopenvino.AxisSet) -> None:
        ...
class BinaryElementwiseArithmetic:
    def __repr__(self) -> str:
        ...
class BinaryElementwiseComparison:
    def __repr__(self) -> str:
        ...
class BinaryElementwiseLogical:
    def __repr__(self) -> str:
        ...
class BodyOutputDescription(OutputDescription):
    """
    openvino.impl.op.util.BodyOutputDescription wraps ov::op::util::BodyOutputDescription
    """
    @typing.overload
    def __init__(self) -> None:
        ...
    @typing.overload
    def __init__(self, body_value_index: typing.SupportsInt, output_index: typing.SupportsInt, iteration: typing.SupportsInt = -1) -> None:
        ...
    def __repr__(self) -> str:
        ...
    def copy(self) -> OutputDescription:
        ...
    def get_type_info(self) -> openvino._pyopenvino.DiscreteTypeInfo:
        ...
    @property
    def body_value_index(self) -> int:
        ...
    @property
    def iteration(self) -> int:
        ...
    @property
    def output_index(self) -> int:
        ...
class ConcatOutputDescription(OutputDescription):
    """
    openvino.impl.op.util.ConcatOutputDescription wraps ov::op::util::ConcatOutputDescription
    """
    @typing.overload
    def __init__(self) -> None:
        ...
    @typing.overload
    def __init__(self, body_value_index: typing.SupportsInt, output_index: typing.SupportsInt, start: typing.SupportsInt, stride: typing.SupportsInt, part_size: typing.SupportsInt, end: typing.SupportsInt, axis: typing.SupportsInt) -> None:
        ...
    def __repr__(self) -> str:
        ...
    def copy(self) -> OutputDescription:
        ...
    def get_type_info(self) -> openvino._pyopenvino.DiscreteTypeInfo:
        ...
    @property
    def axis(self) -> int:
        ...
    @property
    def body_value_index(self) -> int:
        ...
    @property
    def end(self) -> int:
        ...
    @property
    def output_index(self) -> int:
        ...
    @property
    def part_size(self) -> int:
        ...
    @property
    def start(self) -> int:
        ...
    @property
    def stride(self) -> int:
        ...
class IndexReduction:
    index_element_type: openvino._pyopenvino.Type
    def __repr__(self) -> str:
        ...
    def get_index_element_type(self) -> openvino._pyopenvino.Type:
        ...
    def get_reduction_axis(self) -> int:
        ...
    def set_index_element_type(self, arg0: openvino._pyopenvino.Type) -> None:
        ...
    def set_reduction_axis(self, arg0: typing.SupportsInt) -> None:
        ...
    @property
    def reduction_axis(self) -> int:
        ...
    @reduction_axis.setter
    def reduction_axis(self, arg1: typing.SupportsInt) -> None:
        ...
class InputDescription:
    def __init__(self) -> None:
        ...
    def __repr__(self) -> str:
        ...
    def copy(self) -> InputDescription:
        ...
class InvariantInputDescription(InputDescription):
    """
    openvino.impl.op.util.InvariantInputDescription wraps ov::op::util::InvariantInputDescription
    """
    @typing.overload
    def __init__(self) -> None:
        ...
    @typing.overload
    def __init__(self, input_index: typing.SupportsInt, body_parameter_index: typing.SupportsInt) -> None:
        ...
    def __repr__(self) -> str:
        ...
    def copy(self) -> InputDescription:
        ...
    def get_type_info(self) -> openvino._pyopenvino.DiscreteTypeInfo:
        ...
    @property
    def body_parameter_index(self) -> int:
        ...
    @property
    def input_index(self) -> int:
        ...
class MergedInputDescription(InputDescription):
    """
    openvino.impl.op.util.MergedInputDescription wraps ov::op::util::MergedInputDescription
    """
    @typing.overload
    def __init__(self) -> None:
        ...
    @typing.overload
    def __init__(self, input_index: typing.SupportsInt, body_parameter_index: typing.SupportsInt, body_value_index: typing.SupportsInt) -> None:
        ...
    def __repr__(self) -> str:
        ...
    def copy(self) -> InputDescription:
        ...
    def get_type_info(self) -> openvino._pyopenvino.DiscreteTypeInfo:
        ...
    @property
    def body_parameter_index(self) -> int:
        ...
    @property
    def body_value_index(self) -> int:
        ...
    @property
    def input_index(self) -> int:
        ...
class OutputDescription:
    def __init__(self) -> None:
        ...
    def __repr__(self) -> str:
        ...
    def copy(self) -> OutputDescription:
        ...
class SliceInputDescription(InputDescription):
    """
    openvino.impl.op.util.SliceInputDescription wraps ov::op::util::SliceInputDescription
    """
    @typing.overload
    def __init__(self) -> None:
        ...
    @typing.overload
    def __init__(self, input_index: typing.SupportsInt, body_parameter_index: typing.SupportsInt, start: typing.SupportsInt, stride: typing.SupportsInt, part_size: typing.SupportsInt, end: typing.SupportsInt, axis: typing.SupportsInt) -> None:
        ...
    def __repr__(self) -> str:
        ...
    def copy(self) -> InputDescription:
        ...
    def get_type_info(self) -> openvino._pyopenvino.DiscreteTypeInfo:
        ...
    @property
    def axis(self) -> int:
        ...
    @property
    def body_parameter_index(self) -> int:
        ...
    @property
    def end(self) -> int:
        ...
    @property
    def input_index(self) -> int:
        ...
    @property
    def part_size(self) -> int:
        ...
    @property
    def start(self) -> int:
        ...
    @property
    def stride(self) -> int:
        ...
class UnaryElementwiseArithmetic:
    def __repr__(self) -> str:
        ...
class Variable:
    """
    openvino.op.util.Variable wraps ov::op::util::Variable
    """
    def __init__(self, info: VariableInfo) -> None:
        ...
    def __repr__(self) -> str:
        ...
    def get_info(self) -> VariableInfo:
        ...
    def update(self, variable_info: VariableInfo) -> None:
        ...
    @property
    def info(self) -> VariableInfo:
        ...
class VariableInfo:
    """
    openvino.op.util.VariableInfo wraps ov::op::util::VariableInfo
    """
    data_shape: openvino._pyopenvino.PartialShape
    data_type: openvino._pyopenvino.Type
    variable_id: str
    def __init__(self) -> None:
        ...
    def __repr__(self) -> str:
        ...
