# type: ignore
from __future__ import annotations
import collections.abc
import openvino._pyopenvino
import typing
"""
openvino.properties.hint submodule that simulates ov::hint
"""
__all__: list[str] = ['ExecutionMode', 'ModelDistributionPolicy', 'PerformanceMode', 'Priority', 'SchedulingCoreType', 'activations_scale_factor', 'allow_auto_batching', 'compiled_blob', 'dynamic_quantization_group_size', 'enable_cpu_pinning', 'enable_cpu_reservation', 'enable_hyper_threading', 'execution_mode', 'inference_precision', 'kv_cache_precision', 'model', 'model_distribution_policy', 'model_priority', 'num_requests', 'performance_mode', 'scheduling_core_type']
class ExecutionMode:
    """
    Members:
    
      PERFORMANCE
    
      ACCURACY
    """
    ACCURACY: typing.ClassVar[ExecutionMode]  # value = <ExecutionMode.ACCURACY: 2>
    PERFORMANCE: typing.ClassVar[ExecutionMode]  # value = <ExecutionMode.PERFORMANCE: 1>
    __members__: typing.ClassVar[dict[str, ExecutionMode]]  # value = {'PERFORMANCE': <ExecutionMode.PERFORMANCE: 1>, 'ACCURACY': <ExecutionMode.ACCURACY: 2>}
    def __eq__(self, other: typing.Any) -> bool:
        ...
    def __ge__(self, other: typing.Any) -> bool:
        ...
    def __getstate__(self) -> int:
        ...
    def __gt__(self, other: typing.Any) -> bool:
        ...
    def __hash__(self) -> int:
        ...
    def __index__(self) -> int:
        ...
    def __init__(self, value: typing.SupportsInt) -> None:
        ...
    def __int__(self) -> int:
        ...
    def __le__(self, other: typing.Any) -> bool:
        ...
    def __lt__(self, other: typing.Any) -> bool:
        ...
    def __ne__(self, other: typing.Any) -> bool:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, state: typing.SupportsInt) -> None:
        ...
    def __str__(self) -> str:
        ...
    @property
    def name(self) -> str:
        ...
    @property
    def value(self) -> int:
        ...
class ModelDistributionPolicy:
    """
    Members:
    
      TENSOR_PARALLEL
    
      PIPELINE_PARALLEL
    """
    PIPELINE_PARALLEL: typing.ClassVar[ModelDistributionPolicy]  # value = <ModelDistributionPolicy.PIPELINE_PARALLEL: 1>
    TENSOR_PARALLEL: typing.ClassVar[ModelDistributionPolicy]  # value = <ModelDistributionPolicy.TENSOR_PARALLEL: 0>
    __members__: typing.ClassVar[dict[str, ModelDistributionPolicy]]  # value = {'TENSOR_PARALLEL': <ModelDistributionPolicy.TENSOR_PARALLEL: 0>, 'PIPELINE_PARALLEL': <ModelDistributionPolicy.PIPELINE_PARALLEL: 1>}
    def __eq__(self, other: typing.Any) -> bool:
        ...
    def __ge__(self, other: typing.Any) -> bool:
        ...
    def __getstate__(self) -> int:
        ...
    def __gt__(self, other: typing.Any) -> bool:
        ...
    def __hash__(self) -> int:
        ...
    def __index__(self) -> int:
        ...
    def __init__(self, value: typing.SupportsInt) -> None:
        ...
    def __int__(self) -> int:
        ...
    def __le__(self, other: typing.Any) -> bool:
        ...
    def __lt__(self, other: typing.Any) -> bool:
        ...
    def __ne__(self, other: typing.Any) -> bool:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, state: typing.SupportsInt) -> None:
        ...
    def __str__(self) -> str:
        ...
    @property
    def name(self) -> str:
        ...
    @property
    def value(self) -> int:
        ...
class PerformanceMode:
    """
    Members:
    
      LATENCY
    
      THROUGHPUT
    
      CUMULATIVE_THROUGHPUT
    """
    CUMULATIVE_THROUGHPUT: typing.ClassVar[PerformanceMode]  # value = <PerformanceMode.CUMULATIVE_THROUGHPUT: 3>
    LATENCY: typing.ClassVar[PerformanceMode]  # value = <PerformanceMode.LATENCY: 1>
    THROUGHPUT: typing.ClassVar[PerformanceMode]  # value = <PerformanceMode.THROUGHPUT: 2>
    __members__: typing.ClassVar[dict[str, PerformanceMode]]  # value = {'LATENCY': <PerformanceMode.LATENCY: 1>, 'THROUGHPUT': <PerformanceMode.THROUGHPUT: 2>, 'CUMULATIVE_THROUGHPUT': <PerformanceMode.CUMULATIVE_THROUGHPUT: 3>}
    def __eq__(self, other: typing.Any) -> bool:
        ...
    def __ge__(self, other: typing.Any) -> bool:
        ...
    def __getstate__(self) -> int:
        ...
    def __gt__(self, other: typing.Any) -> bool:
        ...
    def __hash__(self) -> int:
        ...
    def __index__(self) -> int:
        ...
    def __init__(self, value: typing.SupportsInt) -> None:
        ...
    def __int__(self) -> int:
        ...
    def __le__(self, other: typing.Any) -> bool:
        ...
    def __lt__(self, other: typing.Any) -> bool:
        ...
    def __ne__(self, other: typing.Any) -> bool:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, state: typing.SupportsInt) -> None:
        ...
    def __str__(self) -> str:
        ...
    @property
    def name(self) -> str:
        ...
    @property
    def value(self) -> int:
        ...
class Priority:
    """
    Members:
    
      LOW
    
      MEDIUM
    
      HIGH
    
      DEFAULT
    """
    DEFAULT: typing.ClassVar[Priority]  # value = <Priority.MEDIUM: 1>
    HIGH: typing.ClassVar[Priority]  # value = <Priority.HIGH: 2>
    LOW: typing.ClassVar[Priority]  # value = <Priority.LOW: 0>
    MEDIUM: typing.ClassVar[Priority]  # value = <Priority.MEDIUM: 1>
    __members__: typing.ClassVar[dict[str, Priority]]  # value = {'LOW': <Priority.LOW: 0>, 'MEDIUM': <Priority.MEDIUM: 1>, 'HIGH': <Priority.HIGH: 2>, 'DEFAULT': <Priority.MEDIUM: 1>}
    def __eq__(self, other: typing.Any) -> bool:
        ...
    def __ge__(self, other: typing.Any) -> bool:
        ...
    def __getstate__(self) -> int:
        ...
    def __gt__(self, other: typing.Any) -> bool:
        ...
    def __hash__(self) -> int:
        ...
    def __index__(self) -> int:
        ...
    def __init__(self, value: typing.SupportsInt) -> None:
        ...
    def __int__(self) -> int:
        ...
    def __le__(self, other: typing.Any) -> bool:
        ...
    def __lt__(self, other: typing.Any) -> bool:
        ...
    def __ne__(self, other: typing.Any) -> bool:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, state: typing.SupportsInt) -> None:
        ...
    def __str__(self) -> str:
        ...
    @property
    def name(self) -> str:
        ...
    @property
    def value(self) -> int:
        ...
class SchedulingCoreType:
    """
    Members:
    
      ANY_CORE
    
      PCORE_ONLY
    
      ECORE_ONLY
    """
    ANY_CORE: typing.ClassVar[SchedulingCoreType]  # value = <SchedulingCoreType.ANY_CORE: 0>
    ECORE_ONLY: typing.ClassVar[SchedulingCoreType]  # value = <SchedulingCoreType.ECORE_ONLY: 2>
    PCORE_ONLY: typing.ClassVar[SchedulingCoreType]  # value = <SchedulingCoreType.PCORE_ONLY: 1>
    __members__: typing.ClassVar[dict[str, SchedulingCoreType]]  # value = {'ANY_CORE': <SchedulingCoreType.ANY_CORE: 0>, 'PCORE_ONLY': <SchedulingCoreType.PCORE_ONLY: 1>, 'ECORE_ONLY': <SchedulingCoreType.ECORE_ONLY: 2>}
    def __eq__(self, other: typing.Any) -> bool:
        ...
    def __ge__(self, other: typing.Any) -> bool:
        ...
    def __getstate__(self) -> int:
        ...
    def __gt__(self, other: typing.Any) -> bool:
        ...
    def __hash__(self) -> int:
        ...
    def __index__(self) -> int:
        ...
    def __init__(self, value: typing.SupportsInt) -> None:
        ...
    def __int__(self) -> int:
        ...
    def __le__(self, other: typing.Any) -> bool:
        ...
    def __lt__(self, other: typing.Any) -> bool:
        ...
    def __ne__(self, other: typing.Any) -> bool:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, state: typing.SupportsInt) -> None:
        ...
    def __str__(self) -> str:
        ...
    @property
    def name(self) -> str:
        ...
    @property
    def value(self) -> int:
        ...
@typing.overload
def activations_scale_factor() -> str:
    ...
@typing.overload
def activations_scale_factor(arg0: typing.SupportsFloat) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
@typing.overload
def allow_auto_batching() -> str:
    ...
@typing.overload
def allow_auto_batching(arg0: bool) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
@typing.overload
def compiled_blob() -> str:
    ...
@typing.overload
def compiled_blob(arg0: openvino._pyopenvino.Tensor) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
@typing.overload
def dynamic_quantization_group_size() -> str:
    ...
@typing.overload
def dynamic_quantization_group_size(arg0: typing.SupportsInt) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
@typing.overload
def enable_cpu_pinning() -> str:
    ...
@typing.overload
def enable_cpu_pinning(arg0: bool) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
@typing.overload
def enable_cpu_reservation() -> str:
    ...
@typing.overload
def enable_cpu_reservation(arg0: bool) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
@typing.overload
def enable_hyper_threading() -> str:
    ...
@typing.overload
def enable_hyper_threading(arg0: bool) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
@typing.overload
def execution_mode() -> str:
    ...
@typing.overload
def execution_mode(arg0: ExecutionMode) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
@typing.overload
def inference_precision() -> str:
    ...
@typing.overload
def inference_precision(arg0: openvino._pyopenvino.Type) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
@typing.overload
def kv_cache_precision() -> str:
    ...
@typing.overload
def kv_cache_precision(arg0: openvino._pyopenvino.Type) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
@typing.overload
def model() -> str:
    ...
@typing.overload
def model(arg0: openvino._pyopenvino.Model) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
@typing.overload
def model_distribution_policy() -> str:
    ...
@typing.overload
def model_distribution_policy(arg0: collections.abc.Set[ModelDistributionPolicy]) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
@typing.overload
def model_priority() -> str:
    ...
@typing.overload
def model_priority(arg0: Priority) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
@typing.overload
def num_requests() -> str:
    ...
@typing.overload
def num_requests(arg0: typing.SupportsInt) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
@typing.overload
def performance_mode() -> str:
    ...
@typing.overload
def performance_mode(arg0: PerformanceMode) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
@typing.overload
def scheduling_core_type() -> str:
    ...
@typing.overload
def scheduling_core_type(arg0: SchedulingCoreType) -> tuple[str, openvino._pyopenvino.OVAny]:
    ...
